//
//  GHMoveIQData.h
//  Garmin Health
//
//  Created by Timar, Mihai on 14/12/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GHActivityType.h"

/**
 * Move IQ data representing a detected activity. Could represent partial data if a sync or midnight happens during the activity.
 */
@interface GHMoveIQData : NSObject

/** Name of the detected activity */
@property (nonatomic, readonly) NSString* activityName;

/** Type of the detected activity. See GHActivityType */
@property (nonatomic, readonly) GHActivityType activityType;

/** Duration of the activity in minutes */
@property (nonatomic, readonly) NSNumber* duration;

/** Timestamp at the start of activity.*/
@property (nonatomic, readonly) NSDate* timestamp;

/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
